// JavaScript Implementation
// -------------------------

/*
	SAFETY NOTICE: There is no security in browser javascript.
	This example script is for use in a server like node.js
*/

var LiveTrack24_API = "http://api.livetrack24.com/api/v2/gzip/1/op/";

// test key and secret, will be valid for limited time
//
var appSecret = "83523469867234672146"; // !!!!!!!!! replace it with yours
var appKey = "00DE262";                 // !!!!!!!!! replace it with yours

// if you cannot get the device id create a random one once!
//
if ( !myRead("deviceID") ) myWrite("deviceID", md5( Date.UTC() + Math.random() ) );

// replace this with a read function to read data (client side) from cookies/session/storage/db
//
function myRead(name)
{
	return ( localStorage.hasOwnProperty(name) ) ? localStorage[name] : 0;
}

// replace this with a write function to read data (client side) from cookies/session/storage/db
//
function myWrite(name, val)
{
	return localStorage[name] = val;
}

// http://code.google.com/p/crypto-js/#Progressive_HMAC_Hashing
//
function otpReply(question)
{
	return '/ak/' + appKey + '/vc/'
		+ (CryptoJS.HmacSHA256(question, appSecret) + "").substr(0,16);
}

// You call this with the rest of the API and it handles the OTP for you.
//
// e.g.:
//
//      callLiveTrack24(url, function(res){
//              // LiveTrack24 data in res
//      });
//

function callLiveTrack24(params, calledSelf, callback)
{
	if ( typeof calledSelf === 'function' )
	{
		callback = calledSelf;
		calledSelf = 0;
	}

	var URL = LiveTrack24_API + params + otpReply( myRead('qwe') );

	if ( calledSelf ) URL += '/di/' + myRead('deviceID') + '/ut/' + myRead('ut');

	getURLContents(URL, function(res)
	{
		if ( res.hasOwnProperty('ut') ) myWrite('ut', res.ut);
		if ( res.hasOwnProperty('qwe') && ( res.qwe != '' ) )
		{
			myWrite('qwe', res.qwe);
		}
		else
		{
			// if we come to this point there is something wrong with our implementation
			if ( typeof callback == 'function' ) callback(res);
			return;
		}

		if ( !calledSelf )
		{
			if ( res.hasOwnProperty("newqwe") && parseInt(res.newqwe) )
			{
				res = null;
				callLiveTrack24(params, 1,  function(res)
				{
					if ( res.hasOwnProperty("reLogin") && parseInt(res.reLogin) )
					{
						res = null;
						callLiveTrack24("login/username/" + myRead('username') + "/passe/"
							+ myRead('passe'), 1, function(res)
						{
							if ( res.hasOwnProperty("reLogin") && parseInt(res.reLogin) )
							{
								res.error = 'Wrong LiveTrack24 username or password';
							}
							else
							{
								res = null;
								callLiveTrack24(params, 1, callback);
							}
							if ( res && ( typeof callback == 'function' ) ) callback(res);
						});
					}
					if ( res && ( typeof callback == 'function' ) ) callback(res);
				});
			}
		}
		if ( res && ( typeof callback == 'function' ) ) callback(res);
	});
}

function getURLContents(url, callback)
{
	$.ajax({
		url: url + otpReply(myRead('qwe')) + '?callback=?',
		crossDomain: true,
		dataType: ( url.indexOf('/gzip/1') > -1 ) ? 'text' : 'json',
		beforeSend: function(jqXHR, settings) {
			params = parseQueryString(settings.url);
			url = settings.url.substr(0, settings.url.indexOf('?') );
			for(var i in params)
			{
				url += '/' + i + '/' + params[i];
			}

			// BEGIN remove this
			print("<br>" + url.replace('/op/',"\n\t/op/")
				.replace('/ak/',"\n\t\t/ak/")
			//	.replace("/callback/","\n\t\t\t/callback/")
			);
			// END remove this

			settings.url = url;
		},
		success: function(res)
		{
			// in case of gzip we need to parse the decompressed string
			if ( typeof res == 'string' )
			{
				try {
					res = JSON.parse(res);
				}
				catch (e) {
					res = { error: "Failed to parse server data (" + res.length + ")" };
				}
			}

			if ( typeof callback == 'function' ) callback(res);
		},
		error: function(e, msg)
		{
			if ( e.status != 200 ) msg = 'Connection/URL error.';
			else if ( msg == 'parsererror' ) msg = 'Failed to parse server data.';
			if ( typeof callback == 'function' ) callback({error:msg});
		}
	});
}

function encryptWithKey(str, key)
{
	var sign, keyPos,
	offset = Math.floor(Math.random() * 256),
	multi = Math.floor(Math.random() * 256),
	final = String.fromCharCode(offset, multi),
	helpKey = '!' + key;
	for(var i = 0; i < str.length ; i++ ) {
		keyPos = ( i * multi + offset ) % key.length;
		// if the previous digit from the key is odd, 1 , else -1
		sign = ( helpKey.charCodeAt(keyPos) & 1 ) ? 1 : -1;
		final += String.fromCharCode( str.charCodeAt(i) + ( key.charCodeAt(keyPos) & 0x3f ) * sign );
	}
	final = btoa(final); // base64_encode(final)
	return final.replace('+','-').replace('/','_').replace('=',',');
}

function decryptWithKey(str,key) {
	str = str.replace('-','+').replace('_','/').replace(',','=');
	str = atob(str);  // base64_decode(str)
	var final="", keypos, keyLen = key.length, sign, goodCode,
		offset = str.charCodeAt(0) & 0xff,
		multi = str.charCodeAt(1) & 0xff,
		helpKey = '!' + key;
	str = str.substr(2);
	for(var i=0; i < str.length; i++)
	{
		keypos = ( i * multi + offset ) % keyLen;
		// if the previous digit from the key is odd, 1 , else -1
		sign = ( helpKey.charCodeAt(keypos) & 1 ) ? 1 : -1;
		goodCode = ( ( str.charCodeAt(i) & 0xff ) - ( key.charCodeAt(keypos) & 0x3f ) * sign ) & 0xff;
		final += String.fromCharCode(goodCode);
	}
	return final;
}

function parseQueryString(query) {
	var query = query.substr( query.indexOf('?') + 1 ), map = {};
	query.replace(/([^&=]+)=?([^&]*)(?:&+|$)/g, function(match, key, value) {
		(map[key] = map[key] || []).push(value);
	});
	return map;
}
