<?php

// PHP example implementation
// --------------------------

// a sample implementation of the LiveTrack24 API
require_once "api.v2.lib.php";

// login form handling
$username = isset($_REQUEST['name']) ? $_REQUEST['name'] : myRead('LT24_username');
$password = isset($_REQUEST['pass']) ? $_REQUEST['pass'] : decryptWithKey( myRead('LT24_password'), LT24_appSecret);

$_REQUEST = array_replace_recursive($_REQUEST, $_GET);

// logout handling
if ( isset($_REQUEST['logout']) )
{
	// client side user logout
	myWrite('qwe',0);               // trash the OTP-question
	myWrite('ut',0);                // trash the user token
}

define('INTO_LT24', array_key_exists('file', $_GET));
$apiFile = substr( __FILE__, strpos( __FILE__, '/api/') + 5);
$self = INTO_LT24 ? 'api?file=' . base64_encode($apiFile) . "&" : basename(__FILE__) . '?';
$home = INTO_LT24 ? '' : ' [ <a href="../../index.html">Home</a> ]';

// if we have a user token, we are client side logged in
//
if ( myRead('ut') )
{
	$logout = '<a href="' . $self . 'logout=1">Logout</a>';
	echo "<h4>You are logged in as: '" . myRead('LT24_username') . "' (user ID: " . myRead('userID')
		. ") [ $logout ]$home</h4>";
}

//redirect handling
$redirect = ( isset($_REQUEST['qs']) ) ? $_REQUEST['qs'] : myRead('qs');
myWrite('qs', $redirect);

// login form display
if ( empty5( myRead('LT24_username') ) || empty5( myRead('LT24_password') ) || !myRead('ut') )
{
	if ( empty($username) ) $username = myRead('LT24_username') ? myRead('LT24_username') : '';
	if ( empty($password) ) $password = decryptWithKey( myRead('LT24_password'), LT24_appSecret);

	$formError = myRead('formError');
	if ( !is_array($formError) ) $formError = array();
	if ( !array_key_exists('name', $formError) ) $formError['name'] = '';
	if ( !array_key_exists('pass', $formError) ) $formError['pass'] = '';

	// get the username and password if missing
	echo "<h3>LiveTrack24 API Login Demo</h3>
		<table border=0>
			<form action='" . $self . "' method='POST'>
				<tr><td>Username:</td><td><input type='text' value='$username' name='name'><br>
					" . $formError['name'] . "</td></tr>
				<tr><td>Password:</td><td><input type='password' value='$password' name='pass'><br>
					" . $formError['pass'] . "</td></tr>
				<tr><td></td><td>
				<input type='submit' value='Login' name='submit'></td></tr>
			</form>
		</table>" . $home;
}


// login form submit handling
if ( isset($_REQUEST['submit']) )
{
	// save username and the password encrypted
	myWrite('LT24_username', $username);
	myWrite('LT24_password', encryptWithKey(strtolower($password), LT24_appSecret) );

	// login with the username and password
	if ( empty($username) ) $username = 'missingUsername';
	$res = callLiveTrack24("login/username/" . rawurlencode($username) . "/passe/" . myRead('LT24_password'));

	if ( is_array($res) )
	{
		// error handling
		if (  array_key_exists('form', $res) )
		{
			myWrite('formError' , $res['form']);
		}
		else
		{
			myWrite('formError' , '');
			// save the userID and username when we get them
			if ( array_key_exists('userID', $res) ) myWrite('userID', $res['userID']);
			if ( array_key_exists('username', $res) ) myWrite('username', $res['username']);
		}
		//ob_end_clean();
		header("Location: " . $self );
	}
}

// if we have a user token, we are client side logged in
//
if ( myRead('ut') )
{
	if ( !empty($redirect) )
	{
		myWrite('qs','');
		header("Location: " . base64_decode($redirect) );
	}

	echo "<h1>LiveTrack24 API v2 example</h1>";

	$res = demo('User(s) Position Info',
		'Returns the latest position info for the given user list. [and/or userIDs list]',
		'2/detailLevel/-1/userList/manolis,gioanna/userIDs/7,8,9876/waypointsLimit/1');  // LiveTrack24 API call

/*	if ( is_array($res) && array_key_exists('result', $res) )
	{
		$trackIDs = '';
		foreach($res['result'] as $username => $info)
		{
			$trackIDs .= "," . $info['trackID'];
		}
		$trackIDs = ltrim($trackIDs,",");
		if ( !empty($trackIDs) )
		{
			demo('Track Points',
				'Returns the points for the given track ids.',
				'15/trackIDs/' . $trackIDs . '/getPoints/10/ago/0');
		}
	}*/
}

?>