<?php
// PHP example implementation
require_once "api.v2.lib.php";
checkLoggedIn();

// testing area of new API op codes

demo('liveList',
	'Lists live tracks with various filters, one or more filters that make sense can be used in one call.<br><pre>'
	.'/countries -> a list of country codes, e.g.: gr,it<br>'
	.'/lat/[LAT]/lon/[LON]/radius/[KM] -> live tracks in range: e.g.: /lat/40.25234/lon/23.32456/radius/100<br>'
	.'/ids -> a list of userIDs, e.g.: 8,7,1140<br>'
	.'/friends/1 -> request all the friends of the currently logged in user<br>'
	.'/tids -> a list of trackIDs, e.g.: 323453,4234543,233454<br>'
	.'/group -> a groupID, e.g.: 6<br>'
	.'<br>'
	.'/sync -> you get this in each reply from the server, give it back to get only new data<br>'
	//.'<br>'
	//.'/ssyn -> reduces sync data even more but adds complexity, to be documented<br>'
	//.'/schk -> reduces sync data even more but adds complexity, to be documented<br>'
	.'<br></pre>'
	,'liveList/friends/1/ids/7,8'
	, 'request all the friends of the currently logged in user and the users with IDs 7,8 (=Manolis,GUS)');

demo('packed JSON names, liveList jsn example',
	'Optionally, you can request packed JSON names which shrinks the size of the reply.<br>'
	.'<pre>/jsn/1 -> request packed JSON names in userlist, see /<a href="#getJSNSchema">getJSNSchema</a> for the translation table.<br>'
	.'<br></pre>'
	,
	'liveList/jsn/1/friends/1/ids/7,8');

demo('getJSNSchema',
	'Get the current JSON schema translation table.<br><pre>'
	.'/checksum -> you get this from the server, giving it back you only request a table with different checksum.<br>'
	.'If the table has changed you will get the new table with its new checksum <br>'
	.'otherwise you will only get the old checksum back.<br></pre>'
	,
	'getJSNSchema');

echo "<hr>";


