<?php
// PHP example implementation
require_once "api.v2.lib.php";
checkLoggedIn();

demo('tasksList',
'Returns a list of tasks with their basic info.<br>'
.'/taskIDs is optional, e.g. /taskIDs/1257,1260<br>'
.'/gliderCat is optional, default is "all"<br>'
.'<br>notes about the reply:<br>'
.'windowOpen: in local minutes from 0:00 hours, e.g.: windowOpen = 815 -> 13:35 -> 13*60+35 -> 815, is 0 for tasks not set yet.<br>'
.'windowOpenTM: is unixtime in UTC, is at 0:00 hours for tasks with windowOpen = 0.',
'tasksList/tasksToGet/2/gliderCat/1,2,16');

demo('getCompWaypoints',
	'Get the comp waypoints for the given task.<br>The return format is: <b>"name,description,lat,lon,alt"</b>.',
	'getCompWaypoints/taskID/1257');

demo('getTaskDef',
'Returns the task definition for the given taskID.<br>',
'getTaskDef/taskID/1257');

echo 'Task Definition:<pre>
t1.1 race wo1340 wc+200 so+20 tc1900 d03 b42.ss.r4000 b43 b55 b54 a06.es.r1000 a06.gl.r200
t1.1 → arbitrary string for identifying the task, not used
race → type of task, currently is not taken into account
wo1340 → Window Open 13:40 local time
wc+200 → window Close +2:00 hrs after window open
so+20 → Start opens +20 mins after Window open
tc1900 → Task deadline is 19:00
d03 → takeoff is turnpoint D03xxx (only enter the first 3 chars of the name) radius is 400m
b42.ss.r4000 → Start of speed section is B42xxx with a radious of 4km
b43 → next tp ( if no .rXXXX is defined, then the default radious of 400m is assumed)
b55  → next tp
b54  → next tp
a06.es.r1000  → End of speed section is TP A06xxx with a radious of 1000m
a06.gl.r200 → Goal is A06xxx with a radious of 200m</pre>';

$taskDef = urlencode('t1.1 race wo1130 wc1330 so1240 tc1715 d01 b31.ss.r9000 b31.r5000 b26 b40 b22.r7000 b05.r8000 b24.ce.g3.r900 b24.r200');
demo('setTask',
	'Set the task definition for the given taskID.<br>',
	'setTask/taskID/1257/pass/wrongPass/minDist/7/taskDef/' . $taskDef);


demo('getTaskPilots',
'Returns a list of pilots for a given task.',
'getTaskPilots/taskID/1257');

demo('getTaskPilotsDetailed',
'Returns a detailed list of pilots for a given task.',
'getTaskPilotsDetailed/taskID/1257');

demo('getTaskKML',
	'Get the task waypoints in KML format. For use in 3D players.',
	'getTaskKML/taskID/1257');

demo('getTaskScoring',
	'Get the latest task scoring.',
	'getTaskScoring/taskID/1257');




