<?php
// PHP example implementation
require_once "api.v2.lib.php";
checkLoggedIn();

demo('Get Track Points',
	'Get tack point data for multiple users after a given time.<br>'
	.'/userList -> a list a usernames<br>'
	.'/userIDs -> a list a user IDs<br>'
	.'/trackIDs -> a list a track IDs<br>'
	.'one of the above is enough but they can co-exist<br>'
	.'<br>'
	.'/fromTM is optional<br>'
	.'/sync is a number that handles GPS points with lag. You should append the sync number you get to the next call e.g. /sync/12345 and the response will also have any delayed GPS points before fromTM. The sync number can be a unixtime, 0 or an integer ID.<br>'
	.'/limit is optional indicating the total number of points allowed to be returned<br>'
	.'the tack format is: [username]:[userID]:[TMs delta]:[Lats delta]:[Lons delta]:[Alts delta]:[SOGs delta]:[COGs delta]:[AGLs delta]:[Vario delta]<br>'
	.'<br>To get the track fields:<pre>'
	.'1. explode(":", track)<br>'
	.'2. in the result array you get 1st the username then the userID, etc.'
	. '</pre>'
	.'Delta unpack:<pre>1. replace "-" with ",-"<br>'
	.'2. explode(",", delta) <br>'
	.'3. get the 1st value <br>'
	.'5. Starting from the 2nd value, for each delta value add it to the previous to get the original value.</pre>'
	.'Divide Lats and Lons with 60000 and Alts with 100 to convert them to floats.<br>'
	.'Multiply COGs by 2.<br>'
	, 'getTrackPoints/userList/gioanna,mitsospro,manolis/userIDs/8/trackIDs/315843/fromTM/1385390182');

echo 'Pseudo code how to get the track data from a track string:<pre>

trackFields = explode(":", trackStr)

username = trackFields[0]
userID = trackFields[1]
TMs = unpackDelta( trackFields[2] )
Lats = unpackDelta( trackFields[3] )
Lons = unpackDelta( trackFields[4] )
Alts = unpackDelta( trackFields[5] )
SOGs = unpackDelta( trackFields[6] )
COGs = unpackDelta( trackFields[7] )
AGLs = unpackDelta( trackFields[8] )
VROs = unpackDelta( trackFields[9] )

for i in Lats
    Lats[i] = Lats[i] / 60000
    Lons[i] = Lons[i] / 60000
    VROs[i] = VROs[i] / 100
    COGs[i] = COGs[i] * 2
end for

// all ready

begin function unpackDelta(deltaStr)
    replace "-" with ",-" in deltaStr
    deltaArray = explode(",", deltaStr)
    for i in deltaArray
        if i > 0 then deltaArray[i] = deltaArray[i] + deltaArray[ i - 1 ]
    end for
    return deltaArray
end function unpackDelta</pre>';

/*demo('Track Points',
	'Returns the points for the given user names list and or user ids list.',
	'15/userList/GUS,mitsospro,sakis/trackIDs/288543/getPoints/10/ago/0');*/

demo('getTaskPoints',
'Get the GPS points of a given taskID. See <a href="#Get_Track_Points">above</a> how to use it.',
'getTaskPoints/taskID/1257/fromTM/1391895000/sync/0');

echo "<hr>";

