
				
// Developed by Manolis Andreadakis - www.livetrack24.com 

mobile=false;


var countryButtons="";
var genterButtons="";

var filterValuesArrays={};


$(document).ready(function() {
	init(); 
});


function init() {
	for (var filter in filters) {
		if (filters.hasOwnProperty(filter)) {
			filterValuesArrays[filter]={};
		}
	}
    //--------------------------------------------------------------------------------
	$('.fs_res_res_row').each(function ($this) {
		for (var filter in filters) {
			if (filters.hasOwnProperty(filter)) {
				var value=$(this).data(filter.toLowerCase());
				if (value) {
					if (! filterValuesArrays[filter][value]) filterValuesArrays[filter][value]=0;
					filterValuesArrays[filter][value]++;
				}
			}
		}
	});

	
	countryButtons+="<button class='btn btn-default btn-primary natButton filterButton' data-filter='nat' data-nat='all'>ALL Nations</button>";
	for (countryCode in filterValuesArrays['nat']) {
		if (filterValuesArrays['nat'].hasOwnProperty(countryCode)) {
			countryButtons+="<img src='http://www.livetrack24.com/img/flags/32/"+countryCode+".png' class='btn btn-default natButton filterButton' data-filter='nat'  data-nat='"+countryCode+"' \>";
		}
	}
	$("#countryButtonsDiv").html(countryButtons);
	
	//--------------------------------------------------------------------------------
	
	genterButtons+="<button class='btn  btn-default btn-primary genderButton filterButton' data-filter='gender' data-gender='all'>Male and Female</button>";
	genterButtons+="<button class='btn  btn-default genderButton filterButton' data-filter='gender' data-gender='woman'>Female</button>";
	
	$("#genderButtonsDiv").html(genterButtons);
	
	//--------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------
	
	for (var filter in filters) {
		if (filters.hasOwnProperty(filter)) {
		
			if (filter=='nat') continue;
			if (filter=='gender') continue;
			
			var Buttons="<button class='btn btn-default btn-primary "+filter+"Button filterButton' data-filter='"+ 
					filter +"' data-"+ filter + " = 'all' > " + filters[filter]['allText'] + " </button>";
			
			for (value in filterValuesArrays[filter]) {
				if (filterValuesArrays[filter].hasOwnProperty(value)) {
					Buttons+='<button class="btn btn-default ' + filter + 'Button filterButton" data-filter="' + filter + '" data-'+filter+'="'+value+'">'+value+'</button>';
				}
			}
			$("#filterButtonsDiv").append("<div id='"+filter+"ButtonsDiv'></div>");
			$("#"+filter+"ButtonsDiv").html(Buttons);
			
		}
	}
	
	
	$('.filterButton').on("click",function() { 
		var filter=$(this).data('filter');
		var buttonName="."+filter+"Button";
		var filterArray=filters[filter];
	
		var value=$(this).data(filter.toLowerCase());
		if (value=='all') {
		  $(buttonName).removeClass('btn-primary');
		  $(buttonName+"[data-"+filter+"='" + value + "']").addClass('btn-primary');
		} else {
			$(buttonName+"[data-"+filter+"='all']").removeClass('btn-primary');
			if ( $(this).hasClass('btn-primary')) { // hide 
				$(buttonName+"[data-"+filter+"='" + value + "']").removeClass('btn-primary');								
			} else { 
				$(buttonName+"[data-"+filter+"='" + value + "']").addClass('btn-primary');
			}
		}
		filterList();
	} );
		
		
	// /do initial filtering 
	filterList(); 

}


function filterList () {
	// hide all results to start with
	$('.rowResult').hide();

	var allNum=0;
	var subresultTexts={};
	var i=1;
	var classStr='';
	
	for (var filter in filters) {
		if (filters.hasOwnProperty(filter)) {
			classStr+=".s"+i;
			subresultTexts[filter]='';
			$('.rowResult').removeClass('s'+i);
			$("."+filter+"Button").each(function ($this) {
				var value=$(this).data(filter.toLowerCase());
				if (value=='all') {
					if ( $(this).hasClass('btn-primary')) {
						allNum++;
						$(".rowResult").addClass('s'+i);
					}
				} else {	
					if ( $(this).hasClass('btn-primary')) { // show it 																		
						$(".rowResult[data-"+filter+"='" + value + "']").addClass('s'+i);
						if (value!='undefined') {
							subresultTexts[filter]+=value+" ";
						}
					}
				}
			});
			
			i++;
		}
	}
	
	var subresultText="";
	
	for (var filter in filters) {
		if (filters.hasOwnProperty(filter)) {
			if (subresultTexts[filter] ) {
				subresultText+=" "+filters[filter]['text']+" [ "+subresultTexts[filter]+"]";	
			}
		}
	}		
	
	if (subresultText) {
		subresultText=" ( "+subresultText+" )";
	}
	
	if (allNum==filters.length) {
		$('.rowResult').show();
		subresultText=" ( All pilots )";
	} else {
		$('.rowResult'+classStr).show();		
	}
	
	$("#subtitle").html(subresultText);
	
	reNumberList();
}


function reNumberList() {
	var i=1;
	var lastPoints=-1;
	var k=1;
	var same_start_i=0;
	$('.rowResult:visible').each(function ($this) {

		var points=$(this).find(".cellPoints").html();
		if (points==lastPoints) {
			if (same_start_i==0) same_start_i=i-1;
			$(this).find('td:first-child').html(same_start_i);
			i++;
		} else {
			$(this).find('td:first-child').html(i);
			lastPoints=points;
			same_start_i=0;
			i++;
		}
		
		$(this).removeClass("odd_man");
		$(this).removeClass("odd_woman");
		if (k%2==0) {
			if ( $(this).data('gender')=='woman' ) {
				$(this).addClass("odd_woman");
			} else {
				$(this).addClass("odd_man");
			}
		}
		
		k++;
			
	});
	
}


function togglemobile(){
	mobile=!mobile;
	if(mobile){
	  $(".nomobile").hide();
	  $("#mobile").html("Mobile version");
	} else {
	  $(".nomobile").show();
	  $("#mobile").html("Full version");
	}
}