<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!--  To see the input used for this xslt, check the "Create source.xml file 
        when creating report" menu item under the "Reports" menu in FsComp.
        When checked a .source.xml file is created each time you create a report.
        It shows the actual xml input to the xslt processor.
        This is helpfull if you like to modify this file.
  -->

	<xsl:output method="html" encoding="utf-8" indent="yes" />

	<!--  Set the decimal separator to be used (. or ,) when decimal data is displayed.
        All decimal data in the source is with . and will be displayed with . unless
        formated otherwise using format-number() function.
  -->
	<xsl:variable name="decimal_separator" select="','"/>
	<xsl:decimal-format decimal-separator=',' grouping-separator=' ' />
	<!-- note! make sure both above use same, ie either . or ,!! -->

	<!--  All <xsl:param ... elements will show as a field in a report dialog in 
        FS when creating reports. This means you can define param elements here 
        with a default value and set the value from FS when creating report.
        Some is used simply to display text at the top of the report (ie status), 
        others is used to filter the results (ie women_only, nation, ...).
        If you add filter params you must of course also change the "filter"
        definition below so that the filter params is applied.
				20080518 FS 1.2.3: 
				Removed all "filter" params.
				Moved filtering inside FS so the xml input to the xslt is already filtered.
				the filter_info attribute of FsTaskResults element shows what filter(s) is applied.
  -->
	<xsl:param name="title"></xsl:param>
	<xsl:param name="status">Provisional</xsl:param>
	<!-- filter params -->
	<!--  No of best tasks to use the sum of for each pilot. 
        Default is 'all' which is normally used. -->
	<xsl:param name="top_x_tasks">all</xsl:param>
    <xsl:param name="result_id" select="0"></xsl:param>
    <xsl:param name="tasks" select="0"></xsl:param>
  
	<!--  The node-set that this variable returns is what is used 
        to create the result list.
        Here some of the params above is used.
  -->
    <xsl:variable name="comp_result" select="/Fs/FsCompetition[1]/FsCompetitionResults/FsCompetitionResult[@top=$top_x_tasks and @id=$result_id and @tasks=$tasks]"/>
	<xsl:variable name="filter2" select="/Fs/FsCompetition[1]/FsCompetitionResults[@top=$top_x_tasks]/FsParticipant"/>
	<xsl:variable name="filter_info" select="/Fs/FsCompetition[1]/FsCompetitionResults[@top=$top_x_tasks]/@filter_info"/>
	<xsl:variable name="comp_pilots" select="/Fs/FsCompetition[1]/FsParticipants[1]/FsParticipant"/>
  
  <xsl:variable name="filter" select="$comp_result/FsParticipant"/>
  <xsl:variable name="fai_sanctioning" select="/Fs/FsCompetition[1]/@fai_sanctioning"/>
  <xsl:variable name="task_result_pattern" select="$comp_result/@task_result_pattern"/>
  <xsl:variable name="comp_result_pattern" select="$comp_result/@comp_result_pattern"/>
  <xsl:variable name="lcletters">abcdefghijklmnopqrstuvwxyz</xsl:variable>
  <xsl:variable name="ucletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
  
  

	<!--  Returns a ranking number based on the @points attribute in the element given by the item param.
        Will give same ranking to elements with equal points. 
        NOTE! does NOT work when called inside a sorted node-list!!!
				NOTE! Likly to give wrong rank for some pilots when applied to a filtered node-list.
  -->
	<xsl:template name="calc_rank_from_points" >
		<xsl:param name="item"/>
		<xsl:param name="points"/>
		<xsl:param name="sub" select="0"/>
		<xsl:variable name="found" select="boolean($item/preceding-sibling::node()[1]/@points = $points)"/>
		<xsl:choose>
			<xsl:when test="$found = true()">
				<xsl:call-template name="calc_rank_from_points">
					<xsl:with-param name="item" select="$item/preceding-sibling::node()[1]"/>
					<xsl:with-param name="points" select="$points"/>
					<xsl:with-param name="sub" select="$sub+1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="position()-$sub"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- list of tasks -->
	<xsl:template name="FsTask_list">
		<table class="fs_res">
			<thead>
				<tr class="fs_res_res_row" onmouseover="this.className = 'hover'" onmouseout="this.className='fs_res_res_row'" >
					<th class="fs_res">Task</th>
					<th class="fs_res">Date</th>
					<th class="fs_res">Distance</th>
					<th class="fs_res"></th>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="$comp_result/FsParticipant[1]/FsTask">
					<xsl:variable name="task_id" select="@id"/>
					<xsl:variable name="es" select="/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/FsTaskDefinition/@es"/>
					<xsl:variable name="no_of_startgates" select="count(/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/FsTaskDefinition/FsStartGate)"/>
					<xsl:variable name="task_distance" select="/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/FsTaskScoreParams/@task_distance"/>
					<tr class="fs_res_res_row" onmouseover="this.className = 'hover'" onmouseout="this.className='fs_res_res_row'" >
						<td class="fs_res">
							T<xsl:value-of select="position()"/>
							<xsl:text>&#160;</xsl:text>
							<xsl:value-of select="/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/@name"/>
						</td>
						<td class="fs_res">
							<xsl:value-of select="translate(substring(/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/FsTaskDefinition/FsTurnpoint[1]/@open, 1, 16), 'T', ' ')"/>&#160;&#160;<xsl:value-of select="@name"/>
						</td>
						<td class="fs_res">
							<xsl:if test="$es">
								<xsl:text>&#160;</xsl:text>
								<xsl:value-of select="format-number($task_distance, concat('#0', $decimal_separator, '0'))"/>
								<xsl:text> km</xsl:text>
							</xsl:if>
						</td>
						<td class="fs_res">
							<xsl:choose>
								<xsl:when test="$es and $no_of_startgates > 0">
									<xsl:text>Race to Goal with </xsl:text>
									<xsl:value-of select="$no_of_startgates"/>
									<xsl:text> startgate(s)</xsl:text>
								</xsl:when>
								<xsl:when test="$es and $no_of_startgates = 0">
									<xsl:text>Elapsed time</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>Open Distance</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>

	<!-- record template, used for each pilot in the ranked list of pilots -->
	<xsl:template name="record">
		<xsl:variable name="pilot_id" select="@id"/>
		<xsl:variable name="comp_pilot" select="$comp_pilots[@id=$pilot_id]"/>
		<xsl:variable name="gender">
			<xsl:choose>
			<xsl:when test="$comp_pilot/@female=1">woman</xsl:when>
			<xsl:otherwise>man</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:variable name="category">
        <xsl:value-of select="$comp_pilot/FsCustomAttributes/FsCustomAttribute[@name='Certification']/@value"/>       
		</xsl:variable>  
		
		<tr >
		 <!-- END OF VARIABLES -->
		
		 <!-- show all custom attributes -->
	   
			<xsl:for-each select="$comp_pilot/FsCustomAttributes/FsCustomAttribute">
				<xsl:variable name="customattr"><xsl:value-of select="@name"/></xsl:variable>
				<xsl:attribute name="data-{$customattr}"><xsl:value-of select="@value"/></xsl:attribute>
			</xsl:for-each>
			<xsl:attribute name="class">fs_res_res_row rowResult</xsl:attribute>
	  
			<xsl:attribute name="data-nat"><xsl:value-of select="$comp_pilot/FsCustomAttributes/FsCustomAttribute[@name='iso2']/@value"/></xsl:attribute>
			<xsl:attribute name="data-gender"><xsl:value-of select="$gender"/></xsl:attribute>
			<xsl:attribute name="data-cat"><xsl:value-of select="$category"/></xsl:attribute>
			 
	  
			<td class="fs_res cellRank" align="right">
				<xsl:call-template name="calc_rank_from_points">
					<xsl:with-param name="item" select="."/>
					<xsl:with-param name="points" select="@points"/>
				</xsl:call-template>
			</td>
			<td class="fs_res cellPilotID">
				<xsl:value-of select="@id"/>
			</td>
			<td class="fs_res cellFlag">
				<img><xsl:attribute name="src">http://www.livetrack24.com/img/flags/32/<xsl:value-of select="$comp_pilot/FsCustomAttributes/FsCustomAttribute[@name='iso2']/@value"/>.png</xsl:attribute>
				</img>
			</td>
			<td class="fs_res cellName">
        		<xsl:value-of select="$comp_pilot/@name"/>
			</td>
			<td class="fs_res cellGender">
				<xsl:choose>
				  <xsl:when test="$comp_pilot/@female=1">F</xsl:when>
				  <xsl:otherwise>M</xsl:otherwise>
				</xsl:choose>
      		</td>
			<td class="fs_res cellGlider">
				<xsl:value-of select="/Fs/FsCompetition/FsParticipants/FsParticipant[@id=$pilot_id]/@glider"/>
			</td>
			<td class="fs_res cellSponsor">
				<xsl:value-of select="/Fs/FsCompetition/FsParticipants/FsParticipant[@id=$pilot_id]/@sponsor"/>
			</td>
			<xsl:for-each select="FsTask">
				<xsl:variable name="task_id" select="@id"/>
				<xsl:choose>
					<xsl:when test="@counts='1'">
						<td class="fs_res" style="text-align: right">
							<xsl:value-of select="/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/FsParticipants/FsParticipant[@id=$pilot_id]/FsResult/@points"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="fs_res" style="text-align: right; text-decoration: line-through;">
							<xsl:value-of select="/Fs/FsCompetition/FsTasks/FsTask[@id=$task_id]/FsParticipants/FsParticipant[@id=$pilot_id]/FsResult/@points"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<td class="fs_res cellPoints" style="font-weight: bold; text-align: right">
				<xsl:attribute name="data-points"><xsl:value-of select="@points"/></xsl:attribute>
				<xsl:value-of select="@points"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="/">
		<html>
			<head>
				<script src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
				
				<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" rel="stylesheet" integrity="sha256-7s5uDGW3AHqw6xtJmNNtr+OBRJUlgkNJEo78P4b0yRw= sha512-nNo+yCHEyn0smMxSswnf/OnX6/KwJuZTlNZBjauKhTK0c+zT+q5JOCx0UFhXQ6rJR9jg6Es8gPuD2uZcYDLqSw==" crossorigin="anonymous"></link>

				<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js" integrity="sha256-KXn5puMvxCw+dAYznun+drMdG1IFl3agK0p/pqT9KAo= sha512-2e8qq0ETcfWRI4HJBzQiA3UoyFk6tbNyG+qSaIBZLyW9Xf3sWZHN/lxe9fTh1U45DpPf07yj94KsUHHWe4Yk1A==" crossorigin="anonymous"></script>
		
<script language="javascript">
var filters={
	'nat':{ 'allText':'All Nations' , 'text':'Nation'} ,
	'gender':{ 'allText':'Male and Female', 'text':'' } ,
	'cat':{ 'allText':'All Categories', 'text':'Category' }
  <xsl:for-each select="/Fs/FsCompetition[1]/FsFilterAttributes/FsFilterAttribute">
    ,'<xsl:value-of select="@name"/>':{ 'allText':'All <xsl:value-of select="@name"/>', 'text':'<xsl:value-of select="@name"/>' } 
  </xsl:for-each>
} ;


</script>

<script src="results_fs_init.js" ></script>


<style type="text/css">
				
@media print
{    
    .no-print, .no-print *
    {
        display: none !important;
    }
}

.hover { /* for IE using onmouseover and onmouseout */
  background: red;
  color:white;
}
tr.fs_res_res_row:hover {
  background: red;
  color:white;
}

.gen_woman {
  background: pink;
}
.gen_man {
  background: lightblue;
}
  
tr.odd_man {
  background: #CEEBF5;
}
tr.odd_woman {
  background: #F9D8DE;
}

div.fs_res   {
  font-family: Verdana, Arial, Helvetica, sans-serif;
  font-size: x-small;
}
  
table.fs_res   {
  border:solid 1px gray;
  border-collapse:collapse;
  font-size: x-small;
}
  
td.fs_res   {
  border:solid 1px gray;
  vertical-align:top;
  padding:5px;
}
  
th.fs_res   {
  border:solid 1px gray;
  vertical-align:center;
}
  
.GoLarge{
	height:50px;
	width:213px;
	font-size:large;
}

#countryButtonsDiv {
	width:100%;
}

.cellName img {
	margin-right:4px;
	width: 18px;
}

.cellFlag img {
	margin-right:1px;
	width: 18px;
}

img.btn{
	width:46px;
}

.filterButtons { 
	padding: 13px;
    width: 800px;
    background-color: aliceblue;
}

.filterButtons  div { 
	margin-bottom:10px;
}
				</style>
			</head>
			<body>
				<div class="fs_res">
		
					<img><xsl:attribute name="src">http://www.livetrack24.com/files/events/<xsl:value-of select="/Fs/FsCompetition/@eventcode"/>/banner.jpg</xsl:attribute>
					</img> 
					<div id="filterButtonsDiv" class='no-print filterButtons'>
						<div id="countryButtonsDiv"></div>
						<div id="genderButtonsDiv"></div>				
					</div> 					
				</div>
				<div>
					<div class="fs_res">
						<div class="fs_res" style="width:100%;font-size: xx-small;text-align:right;" >
							<p>
								Report created: <xsl:value-of select="/Fs/FsCompetition/FsCompetitionResults[@top=$top_x_tasks]/@ts"/>
							</p>
						</div>
						<h2>
							<xsl:value-of select="/Fs/FsCompetition/@name"/>
						</h2>
						<p style="font-size:xx-small">
							<xsl:value-of select="/Fs/FsCompetition/@from"/> to <xsl:value-of select="/Fs/FsCompetition/@to"/>
						</p>
						<xsl:if test="string-length($title) > 0">
							<h2>
								<xsl:value-of select="$title"/>
							</h2>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="$top_x_tasks='all'">
								<h3>
									Total results <span id="subtitle">(All pilots)</span>
								</h3>
							</xsl:when>
							<xsl:otherwise>
								<h3>
									Results using top <xsl:value-of select="$top_x_tasks"/> tasks for each pilot
								</h3>
							</xsl:otherwise>
						</xsl:choose>
						<p>
							<xsl:value-of select="$status"/>
						</p>
						<xsl:if test="string-length($filter_info) > 0">
							<p>
								<b>
									Results include only those pilots where <xsl:value-of select="$filter_info"/>
								</b>
							</p>
						</xsl:if>
						<xsl:if test="$top_x_tasks != 'all'">
							<p>
								<b>
									<xsl:choose>
										<xsl:when test="$top_x_tasks = 1">
											Only the score from the best task of each pilot is used for total score.
										</xsl:when>
										<xsl:otherwise>
											Only the scores from the best <xsl:value-of select="$top_x_tasks"/> tasks of each pilot is used for total score.
										</xsl:otherwise>
									</xsl:choose>
								</b>
							</p>
						</xsl:if>
						<xsl:call-template name="FsTask_list"></xsl:call-template>
						<br/>
						<table class="fs_res">
							<thead>
								<tr class="fs_res_res_row" onmouseover="this.className = 'hover'" onmouseout="this.className='fs_res_res_row'" >
									<th class="fs_res">#</th>
									<th class="fs_res">Id</th>
									<th class="fs_res">C</th>
									<th class="fs_res">Name</th>
									<th class="fs_res">G</th>
									<th class="fs_res">Glider</th>
									<th class="fs_res">Sponsor</th>									
									<xsl:for-each select="$comp_result/FsParticipant[1]/FsTask">
										<th class="fs_res">
											<xsl:text>T </xsl:text>
											<xsl:value-of select="position()"/>
										</th>
									</xsl:for-each>
									<th class="fs_res">Total</th>
								</tr>
							</thead>
							<xsl:for-each select="$filter">
								<!-- participant rows -->
								<xsl:call-template name="record"/>
							</xsl:for-each>
						</table>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
